package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bDelegados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bMantenimientoDelegadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaVocesExcelAction.
 *
 * @author jrgil
 */
public class W83bTablaDelegadosExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		W83bMantenimientoDelegadosBean delBean = (W83bMantenimientoDelegadosBean)contexto.get("w83bMantenimientoDelegadosBean");
		contexto.set("w83bMantenimientoDelegadosTempBean",delBean);
	}
	
	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoDelegados_as.xls";
		InputStream inputStream = W83bTablaDelegadosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		wb.setSheetName(0,"Hoja1");
        HSSFSheet sheet = wb.getSheetAt(0);
        
        List listaDelegados = (ArrayList)contexto.get("w83bListaDelegados");
        W83bMantenimientoDelegadosBean delBean = (W83bMantenimientoDelegadosBean)contexto.get("w83bMantenimientoDelegadosTempBean");                     
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                    
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                    
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                   
     
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                   
        HashMap mapaVoces=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                   
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1                   
        HSSFCell cell = row.createCell((short)3);                   
        row = sheet.getRow((short)4);                   
        cell = row.getCell((short)5);                   
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaVoces.get("tituloDepEs");                   
        StringBuffer tituloImagenEu =  (StringBuffer)mapaVoces.get("tituloDepEu");                   
        cell.setCellValue(tituloImagenEu.toString());                   
        
        cell = row.getCell((short)8);                   
        cell.setCellValue(tituloImagenEs.toString());                   
        
        tituloImagenEs = (StringBuffer)mapaVoces.get("tituloDelelegacionEs");                   
        tituloImagenEu = (StringBuffer)mapaVoces.get("tituloDelelegacionEu");                   
        row = sheet.getRow((short)6);                   
        cell = row.getCell((short)5);                   
        cell.setCellValue(tituloImagenEu.toString());                   
        
        cell = row.getCell((short)8);                   
        cell.setCellValue(tituloImagenEs.toString());                   
        
        row = sheet.getRow((short)9);                   
        cell = row.getCell((short)0);                   
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegacion.listadoDelegados").toUpperCase());
        
        //MAPEO FORMULARIO
      //fila 11, columna 2
        row = sheet.getRow(Short.parseShort("12"));
        cell = row.getCell(Short.parseShort("2"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.dniDelegado"));
        cell = row.createCell(Short.parseShort("4"));
        if(!StringUtils.isEmpty(delBean.getDniDelegado())){
        	cell.setCellValue(delBean.getDniDelegado().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        //hasta el 11
      //fila 12, columna 2
        row = sheet.getRow(Short.parseShort("13"));
        cell = row.getCell(Short.parseShort("2"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.territorio"));
        cell = row.createCell(Short.parseShort("4"));
        if(StringUtils.isNotEmpty(delBean.getIdProvincia())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("4"),W83bClsConstantes.TRECE,Short.parseShort("7")));//NOPMD
        	if(StringUtils.isNotEmpty(delBean.getDescProvincia())){
            	cell.setCellValue(delBean.getDescProvincia().toUpperCase());
            }else{
            	if (W83bClsConstantes.CONSTANTE_ALAVA.equals(delBean.getIdProvincia())){
        			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.alava",idioma).toUpperCase());
        		}
            }
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        //fila 12, columna 5
        cell = row.getCell(Short.parseShort("8"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.municipio"));
        cell = row.createCell(Short.parseShort("11"));
        if(StringUtils.isNotEmpty(delBean.getIdMunicipio())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("11"),W83bClsConstantes.TRECE,Short.parseShort("15")));//NOPMD
        	if(StringUtils.isNotEmpty(delBean.getDescMunicipio())){
        		cell.setCellValue(delBean.getDescMunicipio().toUpperCase());
        	}else{
        		if (W83bClsConstantes.CONSTANTE_VITORIA.equals(delBean.getIdMunicipio())){
        			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.vitoria",idioma).toUpperCase());
        		}
        	}
        }else{
        	cell.setCellValue("");
        }
        
        //fila 13, columna 2
        row = sheet.getRow(Short.parseShort("14"));
        cell = row.getCell(Short.parseShort("2"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.nombre"));        
        cell = row.createCell(Short.parseShort("4"));
        if(StringUtils.isNotEmpty(delBean.getNombreDelegado())){
        	cell.setCellValue(delBean.getNombreDelegado().toUpperCase());
        }else{
        	cell.setCellValue("");
  	        	
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        //fila 13, columna 5
        cell = row.getCell(Short.parseShort("8"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.primerApellido"));
        cell = row.createCell(Short.parseShort("11"));
        if(StringUtils.isNotEmpty(delBean.getPrimerApellidoDelegado())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("11"),W83bClsConstantes.CATORCE,Short.parseShort("15")));//NOPMD
        	cell.setCellValue(delBean.getPrimerApellidoDelegado().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
            //fila 13, columna 2
            row = sheet.getRow(Short.parseShort("15"));
            cell = row.getCell(Short.parseShort("2"));
            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.segundoApellido"));        
            cell = row.createCell(Short.parseShort("4"));
            if(StringUtils.isNotEmpty(delBean.getSegundoApellidoDelegado())){
            	cell.setCellValue(delBean.getSegundoApellidoDelegado().toUpperCase());
            }else{
            	cell.setCellValue("");
            }
            cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.QUINCE,excel,wb));
            //fila 13, columna 5
            cell = row.getCell(Short.parseShort("8"));
            cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.baja"));
            cell = row.createCell(Short.parseShort("11"));
            if(StringUtils.isNotEmpty(delBean.getCodBaja())){
            	sheet.addMergedRegion(new Region(W83bClsConstantes.QUINCE,Short.parseShort("11"),W83bClsConstantes.QUINCE,Short.parseShort("15")));//NOPMD
            	if((W83bClsConstantes.DOS+"").equalsIgnoreCase(delBean.getCodBaja())){
            		StringBuffer pfecha = new StringBuffer();
            		pfecha.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegados.fechaBaja",idioma).toUpperCase()).append("  ");
            		if(StringUtils.isNotEmpty(delBean.getFechaBajaDesde())){
            			pfecha.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.desde",idioma).toUpperCase()).append(":");
            			pfecha.append(delBean.getFechaBajaDesde()).append("  ");
            		}
            		if(StringUtils.isNotEmpty(delBean.getFechaBajaHasta())){
            			pfecha.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.hasta",idioma)).append(":");
            			pfecha.append(delBean.getFechaBajaHasta());
            		}
            		
            		cell.setCellValue(pfecha.toString());
            	}else if((W83bClsConstantes.UNO+"").equalsIgnoreCase(delBean.getCodBaja())){
            		cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegados.fechaActivos").toUpperCase());
            	}else{
            		cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegados.fechaTodos").toUpperCase());
            	}
            	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.QUINCE,excel,wb));
            }else{
            	cell.setCellValue("");
            }
        
            	
        //Creamos la cabecera de la tabla
        row = sheet.getRow(Short.parseShort("18")); // Creacin de la fila 16

        cell = row.getCell(Short.parseShort("0"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.numActa"));
        
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.fechaBajaActa"));
        
        cell = row.getCell(Short.parseShort("3"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.nombreApellidos"));
        
        cell = row.getCell(Short.parseShort("5"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.dni"));

        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.sindicato"));
        
        cell = row.getCell(Short.parseShort("7"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.fechaBajaDelegado"));

        cell = row.getCell(Short.parseShort("8"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.telefono"));
        
        cell = row.getCell(Short.parseShort("9"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.razonSocial"));
        
        cell = row.getCell(Short.parseShort("10"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.cifNif"));
        
        cell = row.getCell(Short.parseShort("11"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.registroDefinitivo.direccion"));
        
        cell = row.getCell(Short.parseShort("13"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.provincia"));
        
        cell = row.getCell(Short.parseShort("14"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.municipio"));
        
        cell = row.getCell(Short.parseShort("15"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.faxBusqueda"));
        
        for(int i=0;i<listaDelegados.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIEZYNUEVE+i);//NOPMD
        	W83bMantenimientoDelegadosBean currentDelegado = (W83bMantenimientoDelegadosBean)listaDelegados.get(i);

        	cell = row.createCell(Short.parseShort("0"));
        	StringBuffer numActa = new StringBuffer();//NOPMD
        	if(StringUtils.isNotEmpty(currentDelegado.getNumActaCompleto())){
        		numActa.append(currentDelegado.getNumActaCompleto());
        	}else{
	        	if(StringUtils.isNotEmpty(currentDelegado.getActaTerritorio())){
	        		numActa = numActa.append(currentDelegado.getActaTerritorio()).append("/");
	        	}else{
	        		numActa = numActa.append("-/");
	        	}
	        	if(StringUtils.isNotEmpty(currentDelegado.getActaAnyo())){
	        		numActa = numActa.append(currentDelegado.getActaAnyo()).append("/");
	        	}else{
	        		numActa = numActa.append("-/");
	        	}
	        	if(StringUtils.isNotEmpty(currentDelegado.getActaNum())){
	        		numActa = numActa.append(currentDelegado.getActaNum());
	        	}else{
	        		numActa = numActa.append("-");
	        	}
        	}
        	if(!"".equalsIgnoreCase(numActa+"")){
        		cell.setCellValue(numActa+"");
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));

        	cell = row.createCell(Short.parseShort("1"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("1"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("2")));//NOPMD
        	if(StringUtils.isNotEmpty(currentDelegado.getActaFechaBaja())){
        		cell.setCellValue(currentDelegado.getActaFechaBaja());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell(Short.parseShort("2")); 
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("3"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("3"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("4")));//NOPMD
        	StringBuffer nomDelegado = new StringBuffer();//NOPMD
        	if(StringUtils.isNotEmpty(currentDelegado.getNombreDelegado())){
        		nomDelegado = nomDelegado.append(currentDelegado.getNombreDelegado().toUpperCase()).append(" ");
        	}else{
        		nomDelegado = nomDelegado.append(" ");
        	}
        	if(StringUtils.isNotEmpty(currentDelegado.getPrimerApellidoDelegado())){
        		nomDelegado = nomDelegado.append(currentDelegado.getPrimerApellidoDelegado().toUpperCase()).append(" ");
        	}else{
        		nomDelegado = nomDelegado.append(" ");
        	}
        	if(StringUtils.isNotEmpty(currentDelegado.getSegundoApellidoDelegado())){
        		nomDelegado = nomDelegado.append(currentDelegado.getSegundoApellidoDelegado().toUpperCase()).append(" ");
        	}else{
        		nomDelegado = nomDelegado.append(" ");
        	}
        	if(!"".equalsIgnoreCase(nomDelegado+"")){
        		cell.setCellValue(nomDelegado+"");
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	cell = row.createCell(Short.parseShort("5"));
        	if(StringUtils.isNotEmpty(currentDelegado.getDniDelegado())){
        		cell.setCellValue(currentDelegado.getDniDelegado());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("6"));
        	if(StringUtils.isNotEmpty(currentDelegado.getCodSindicato())){
        		cell.setCellValue(W83bUtilidades.numero(currentDelegado.getCodSindicato()));
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("7"));
        	if(StringUtils.isNotEmpty(currentDelegado.getFechaBaja())){
        		cell.setCellValue(currentDelegado.getFechaBaja());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("8"));
        	if(StringUtils.isNotEmpty(currentDelegado.getTelefono())){
        		cell.setCellValue(currentDelegado.getTelefono());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("9"));
        	if(StringUtils.isNotEmpty(currentDelegado.getRazonSocial())){
        		cell.setCellValue(currentDelegado.getRazonSocial().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFila(i,excel));

        	cell = row.createCell(Short.parseShort("10"));
        	if(StringUtils.isNotEmpty(currentDelegado.getCifNif())){
        		cell.setCellValue(currentDelegado.getCifNif());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("11"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("11"),W83bClsConstantes.DIEZYNUEVE+i,Short.parseShort("12")));//NOPMD
        	if(StringUtils.isNotEmpty(currentDelegado.getDomicilio())){
        		cell.setCellValue(currentDelegado.getDomicilio());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("12")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	cell = row.createCell(Short.parseShort("13"));
        	if(StringUtils.isNotEmpty(currentDelegado.getDescProvincia())){
        		cell.setCellValue(currentDelegado.getDescProvincia());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("14"));
        	if(StringUtils.isNotEmpty(currentDelegado.getDescMunicipio())){
        		cell.setCellValue(currentDelegado.getDescMunicipio());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	cell = row.createCell(Short.parseShort("15"));
        	if(StringUtils.isNotEmpty(currentDelegado.getFax())){
        		cell.setCellValue(currentDelegado.getFax());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        String tituloFich = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegacion.tituloFicheroDelegados",idioma).toUpperCase();
        response.setHeader("Content-disposition","attachment;filename="+tituloFich+".xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		return null;
	}
	

	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
		
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
	}
		
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
